/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import jclass.bwt.JCTextCursorEvent;
import jclass.bwt.JCTextEvent;
import jclass.field.JCValidInfo;
import jclass.field.JCValidator;

public class JCStringValidator
extends JCValidator {
    static final int NUMBER = 0;
    static final int DIGIT = 1;
    static final int HEX = 2;
    static final int UPPER = 3;
    static final int LOWER = 4;
    static final int NOCONVERT = 5;
    static final int STAR = 6;
    static final int ALPHANUMERIC = 7;
    static final int LITERAL = 8;
    static final String HEXDIGITS = "AaBbCcDdEeFf";
    static final String NUMBERDIGITS = "+-,.";
    protected int[] compiled_mask_sym;
    protected char[] compiled_mask_ch;
    protected int mask_length;
    protected int num_editable_pos;
    protected String mask = "";
    protected String place_holder_chars;
    protected String mask_chars = "#@HULA*^\\";
    protected int num_mask_match = -1;

    public Object copyValue(Object object) {
        return object;
    }

    public void setNumMaskMatch(int n) {
        this.num_mask_match = n;
    }

    public int getNumMaskMatch() {
        return this.num_mask_match;
    }

    public void setMask(String string) {
        this.mask = string;
        this.compileMask();
    }

    public String getMask() {
        return this.mask;
    }

    public void setPlaceHolderChars(String string) {
        this.place_holder_chars = string;
    }

    public String getPlaceHolderChars() {
        return this.place_holder_chars;
    }

    public void setMaskChars(String string) {
        if (string.length() != this.mask_chars.length()) {
            throw new IllegalArgumentException("Missing mask chars");
        }
        this.mask_chars = string;
        this.compileMask();
    }

    public String getMaskChars() {
        return this.mask_chars;
    }

    public String getParsedMask() {
        if (this.mask != null && this.mask_length != 0) {
            return String.copyValueOf(this.compiled_mask_ch);
        }
        return "";
    }

    public JCStringValidator() {
        this.spin_policy = 2;
    }

    public JCStringValidator(String string, int n, String string2, String[] stringArray, boolean bl, String string3, String string4, boolean bl2) {
        this();
        this.setMask(string);
        this.setPickList(stringArray);
        this.setMatchPickList(bl);
        this.setNumMaskMatch(n);
        this.setPlaceHolderChars(string2);
        this.setValidChars(string3);
        this.setInvalidChars(string4);
        this.setAllowNull(bl2);
    }

    public boolean inRange(Object object) {
        return true;
    }

    protected void compileMask() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.mask == null || (n = this.mask.length()) == 0) {
            this.mask_length = 0;
            return;
        }
        this.compiled_mask_sym = new int[n];
        this.compiled_mask_ch = new char[n];
        this.num_editable_pos = 0;
        n2 = 0;
        n3 = 0;
        while (n2 < n) {
            n4 = this.mask_chars.indexOf(this.mask.charAt(n2));
            if (n4 < 0) {
                this.compiled_mask_sym[n3] = 8;
                this.compiled_mask_ch[n3] = this.mask.charAt(n2);
            } else if (this.mask.charAt(n2) == this.mask_chars.charAt(8)) {
                if (++n2 < n) {
                    this.compiled_mask_sym[n3] = 8;
                    this.compiled_mask_ch[n3] = this.mask.charAt(n2);
                } else {
                    --n3;
                }
            } else {
                this.compiled_mask_sym[n3] = n4;
                this.compiled_mask_ch[n3] = 32;
                ++this.num_editable_pos;
            }
            ++n2;
            ++n3;
        }
        this.mask_length = n3;
    }

    protected boolean isValidChar(StringBuffer stringBuffer, int n, int n2) {
        char c = stringBuffer.charAt(n);
        if (n2 >= this.mask_length) {
            return false;
        }
        switch (this.compiled_mask_sym[n2]) {
            case 0: {
                return Character.isDigit(c) || NUMBERDIGITS.indexOf(c) >= 0;
            }
            case 2: {
                return Character.isDigit(c) || HEXDIGITS.indexOf(c) >= 0;
            }
            case 1: {
                return Character.isDigit(c);
            }
            case 3: {
                if (Character.isLetter(c)) {
                    stringBuffer.setCharAt(n, Character.toUpperCase(c));
                    return true;
                }
                return false;
            }
            case 4: {
                if (Character.isLetter(c)) {
                    stringBuffer.setCharAt(n, Character.toLowerCase(c));
                    return true;
                }
                return false;
            }
            case 5: {
                return Character.isLetter(c);
            }
            case 6: {
                return true;
            }
            case 8: {
                return c == this.compiled_mask_ch[n2];
            }
            case 7: {
                return Character.isLetter(c) || Character.isDigit(c);
            }
        }
        return false;
    }

    protected int getNextCursorPosition(int n, boolean bl) {
        int n2 = 0;
        if (this.mask == null || this.mask_length == 0) {
            return n;
        }
        if (n == this.mask_length) {
            return n;
        }
        if (bl) {
            n2 = n;
            while (n2 < this.mask_length) {
                if (this.compiled_mask_sym[n2] != 8) {
                    return n2;
                }
                ++n2;
            }
        } else {
            n2 = n;
            while (n2 >= 0) {
                if (this.compiled_mask_sym[n2] != 8) {
                    return n2;
                }
                --n2;
            }
        }
        return -1;
    }

    private void addPlaceHolder(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        if (this.place_holder_chars != null) {
            n2 = this.place_holder_chars.length();
        }
        if (n2 > 0 && n < n2) {
            stringBuffer.append(this.place_holder_chars.charAt(n));
            return;
        }
        stringBuffer.append(" ");
    }

    public void changeText(JCTextEvent jCTextEvent) {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer(50);
        StringBuffer stringBuffer3 = new StringBuffer(50);
        boolean bl = false;
        int n = jCTextEvent.getStartPosition();
        int n2 = jCTextEvent.getEndPosition();
        super.changeText(jCTextEvent);
        if (jCTextEvent.isDeletion() && this.mask != null && this.mask_length != 0) {
            if (this.compiled_mask_sym[n] == 8 && n2 - n == 1) {
                int n3 = this.getNextCursorPosition(n, false);
                if (n3 == -1) {
                    jCTextEvent.setAllowChange(false);
                    return;
                }
                this.addPlaceHolder(stringBuffer3, n3);
                int n4 = n3 + 1;
                while (n4 <= n) {
                    if (this.compiled_mask_sym[n4] == 8) {
                        stringBuffer3.append(this.compiled_mask_ch[n4]);
                    } else {
                        this.addPlaceHolder(stringBuffer3, n4);
                    }
                    ++n4;
                }
                jCTextEvent.setStartPosition(n3);
                jCTextEvent.setText(stringBuffer3.toString());
                return;
            }
            if (n2 - n > 1) {
                StringBuffer stringBuffer4 = new StringBuffer(jCTextEvent.getText());
                int n5 = stringBuffer4.length();
                int n6 = 0;
                int n7 = n;
                while (n7 < n2 && this.compiled_mask_sym[n7] == 8) {
                    ++n;
                    ++n7;
                }
                n7 = n;
                while (n7 < n2) {
                    if (this.compiled_mask_sym[n7] == 8) {
                        stringBuffer3.append(this.compiled_mask_ch[n7]);
                    } else if (!stringBuffer4.equals("") && n6 < n5 && this.isValidChar(stringBuffer4, n6, n7)) {
                        stringBuffer3.append(stringBuffer4.charAt(n6));
                        ++n6;
                    } else {
                        this.addPlaceHolder(stringBuffer3, n7);
                    }
                    ++n7;
                }
                jCTextEvent.setStartPosition(n);
                jCTextEvent.setText(stringBuffer3.toString());
                return;
            }
            this.addPlaceHolder(stringBuffer3, n);
            jCTextEvent.setText(stringBuffer3.toString());
            return;
        }
        String string = jCTextEvent.getText();
        if (string != null && string.length() != 0) {
            stringBuffer = this.checkValidInvalid(string);
            if (stringBuffer != null && stringBuffer.length() != 0) {
                int n8 = n;
                if (this.mask != null && this.mask_length != 0) {
                    int n9 = 0;
                    while (n9 < stringBuffer.length()) {
                        bl = this.isValidChar(stringBuffer, n9, n8);
                        if (bl) {
                            stringBuffer2.append(stringBuffer.charAt(n9));
                            ++n8;
                            if (n2 - n != 1) {
                                int n10 = n8;
                                while (n10 < this.mask_length && this.compiled_mask_sym[n10] == 8) {
                                    stringBuffer2.append(this.compiled_mask_ch[n10]);
                                    ++n10;
                                }
                            }
                            n8 = this.getNextCursorPosition(n8, true);
                        }
                        ++n9;
                    }
                    if (n2 - n != 1) {
                        jCTextEvent.setEndPosition(jCTextEvent.getStartPosition() + stringBuffer2.length());
                    }
                } else {
                    stringBuffer2.append((Object)stringBuffer);
                }
            }
            jCTextEvent.setText(stringBuffer2.toString());
            if (stringBuffer2.length() == 0) {
                jCTextEvent.setAllowChange(false);
            }
        }
    }

    public void setCursor(JCTextCursorEvent jCTextCursorEvent) {
        int n;
        int n2 = jCTextCursorEvent.getNewPosition();
        int n3 = jCTextCursorEvent.getCurrentPosition();
        boolean bl = true;
        if (n3 > n2) {
            bl = false;
        }
        if ((n = this.getNextCursorPosition(n2, bl)) == -1 && (n = this.getNextCursorPosition(n2, !bl)) == -1) {
            jCTextCursorEvent.setNewPosition(jCTextCursorEvent.getCurrentPosition());
            return;
        }
        jCTextCursorEvent.setNewPosition(n);
    }

    public JCValidInfo validateText(String string) {
        String string2;
        if ((string == null || string.length() == 0) && this.getAllowNull() || this.mask == null || this.mask_length == 0) {
            string2 = string;
        } else {
            StringBuffer stringBuffer = new StringBuffer(50);
            int n = string.length();
            while (n > 0) {
                if (this.place_holder_chars == null || n > this.place_holder_chars.length() ? string.charAt(n - 1) != ' ' && this.compiled_mask_sym[n - 1] != 8 : string.charAt(n - 1) != this.place_holder_chars.charAt(n - 1) && this.compiled_mask_sym[n - 1] != 8) break;
                --n;
            }
            int n2 = 0;
            while (n2 < n) {
                if (this.compiled_mask_sym[n2] != 8 || this.compiled_mask_ch[n2] != string.charAt(n2)) {
                    stringBuffer.append(string.charAt(n2));
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return this.internalValidate(string2);
    }

    public JCValidInfo validate(Object object) {
        return this.internalValidate(object);
    }

    protected JCValidInfo internalValidate(Object object) {
        int n = 0;
        int n2 = 0;
        JCValidInfo jCValidInfo = super.validate(object);
        String string = (String)jCValidInfo.value;
        int n3 = -1;
        if (string == null || string.length() == 0 && this.getAllowNull()) {
            jCValidInfo.valid = true;
            jCValidInfo.value = null;
            return jCValidInfo;
        }
        if (!(string != null && string.length() != 0 || this.getAllowNull())) {
            jCValidInfo.valid = false;
        }
        if (!jCValidInfo.valid || this.mask == null || this.mask_length == 0) {
            return jCValidInfo;
        }
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            n = 0;
            while (n < stringBuffer.length()) {
                int n4 = n2;
                while (n4 < this.mask_length && this.compiled_mask_sym[n4] == 8) {
                    ++n2;
                    ++n4;
                }
                if (!this.isValidChar(stringBuffer, n, n2)) {
                    jCValidInfo.valid = false;
                    break;
                }
                ++n2;
                n3 = n++;
            }
            if (this.num_mask_match >= 0) {
                jCValidInfo.valid = this.num_mask_match <= n3 + 1;
            } else if (stringBuffer.length() != this.num_editable_pos) {
                jCValidInfo.valid = false;
            }
        }
        return jCValidInfo;
    }

    public String format(Object object) {
        StringBuffer stringBuffer = new StringBuffer(50);
        int n = 0;
        if (object != null && !this.isSupported(object)) {
            object = this.convertToSupported(object);
        }
        String string = object == null ? "" : (String)object;
        if (this.mask != null && this.mask_length != 0) {
            if (string.length() == 0 && this.place_holder_chars != null && this.place_holder_chars.length() != 0) {
                stringBuffer.append(this.place_holder_chars);
                int n2 = this.place_holder_chars.length();
                while (n2 < this.mask_length) {
                    if (this.compiled_mask_sym[n2] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n2]);
                    } else {
                        this.addPlaceHolder(stringBuffer, n2);
                    }
                    ++n2;
                }
                return stringBuffer.toString();
            }
            int n3 = 0;
            while (n3 < string.length() && n3 < this.num_editable_pos) {
                if (string.charAt(n3) == this.compiled_mask_ch[n] && this.compiled_mask_sym[n] != 8) {
                    stringBuffer.append(this.compiled_mask_ch[n]);
                } else {
                    int n4 = n;
                    while (this.compiled_mask_sym[n4] == 8) {
                        stringBuffer.append(this.compiled_mask_ch[n4]);
                        ++n;
                        ++n4;
                    }
                    stringBuffer.append(string.charAt(n3));
                }
                ++n;
                ++n3;
            }
            n3 = n;
            while (n3 < this.mask_length) {
                if (this.compiled_mask_sym[n3] == 8) {
                    stringBuffer.append(this.compiled_mask_ch[n3]);
                } else {
                    this.addPlaceHolder(stringBuffer, n3);
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public int getFirstValidCursorPosition() {
        if (this.mask != null && this.mask_length != 0) {
            int n = this.getNextCursorPosition(0, true);
            if (n >= 0) {
                return n;
            }
            return this.mask_length;
        }
        return 0;
    }

    public String formatForEdit(Object object) {
        return null;
    }

    public boolean hasEditFormat() {
        return false;
    }

    protected Object addIncrement(Object object) {
        return null;
    }

    protected Object subtractIncrement(Object object) {
        return null;
    }

    public boolean isSupported(Object object) {
        return object instanceof String;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof StringBuffer) {
            return ((StringBuffer)object).toString();
        }
        return null;
    }

    public Object convertFromSupported(Object object, String string) {
        if (string.equals("java.lang.StringBuffer")) {
            return new StringBuffer((String)object);
        }
        return null;
    }
}

